*Title: Time Tracking
Slug: time-tracking

================================================================

The <{term}>Time Tracking<{/term}> tool makes it easy for people to **log how much time they have spent working on a Project or a Task**. This information can be gathered by activeCollab and displayed as a <{term}>Time Report<{/term}>, which can be used for billing clients or for paying employees and subcontractors.

<{note title="Who can track time?"}>All users in activeCollab who have the <{term}>Project Permission<{/term}> for the Time and Expenses section set to at least **Access and Create**, are able to log time entries. The Project Permission does not apply to <{term}>Project Leaders<{/term}>, <{term}>Administrators<{/term}> and <{term}>Project Managers<{/term}>, because they already have full access to the Project.<{/note}> 

<{sub}>Tracking Time on a Task<{/sub}>

After working on a <{term}>Task<{/term}>, you can submit your time record by clicking the <{option}>Clock Icon<{/option}> available in the Task header:

<{image name="submit_time.png"}>

When submitting time records, you can also:

- Select a <{term}>Job Type<{/term}> for the work you have completed. 
- Add a <{term}>Summary<{/term}> of what has been done.
- Set the <{term}>Status<{/term}> for the time entry - Billable, Non-billable, Pending Payment or Paid.

After entering your hours, click <{option}>Add<{/option}> to log your time entry.

<{sub}>Tracking Time on a Project<{/sub}>

In case you have been working on a Project, but your work is not related to a specific Task, you can log time that you have spent by opening the <{option}>Time and Expenses<{/option}> tab. To add a new entry to the log, click the <{option}>Log Time<{/option}> button. 

All the Time and Expenses logged on the Project are displayed on this page.

<{sub}>Tracking Time with activeCollab Timer<{/sub}>

Another way to track time spend working on a <{term}>Project<{/term}> or <{term}>Task<{/term}> is by using the <a href="https://www.activecollab.com/timer.html">activeCollab Timer</a>. This is a desktop application **that will track the time for you**.

activeCollab Timer can be synchronized with your activeCollab. You can find the <{term}>Task<{/term}>, or the <{term}>Project<{/term}> that you are working on, directly in the Timer, track your time and submit the time record in the system. The Timer also allows you to complete a Task when submitting the time log. 

If you decide to take a break and move away from your computer, activeCollab Timer will detect idle time and pause time tracking. When you get back to work, your timer will start automatically. 

Multiple timers are also supported.

<{image name="activecollab_timer.png"}>